/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.api.entity.util;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class RayTraceHelper {
    public static RayTraceResult rayTrace(Entity entity, double distance, float delta) {
        return entity.field_70170_p.func_217299_a(new RayTraceContext(entity.func_174824_e(delta), entity.func_174824_e(delta).func_178787_e(entity.func_70676_i(delta).func_186678_a(distance)), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity));
    }

    public static RayTraceResult rayTraceWithCustomDirection(Entity entity, float pitch, float yaw, double distance, float delta) {
        return entity.field_70170_p.func_217299_a(new RayTraceContext(entity.func_174824_e(delta), entity.func_174824_e(delta).func_178787_e(RayTraceHelper.getVectorForRotation(pitch, yaw).func_186678_a(distance)), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity));
    }

    public static EntityRayTraceResult rayTraceEntityResult(Entity entity, float pitch, float yaw, double distance, double sqDistance, float delta) {
        Vector3d look = RayTraceHelper.getVectorForRotation(pitch, yaw);
        Vector3d endVec = entity.func_174824_e(delta).func_178787_e(look.func_186678_a(distance));
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_216361_a(look.func_186678_a(distance)).func_72314_b(1.0, 1.0, 1.0);
        EntityRayTraceResult entityRaytraceResult = RayTraceHelper.func_221273_a(entity, entity.func_174824_e(delta), endVec, axisalignedbb, result -> !result.func_175149_v() && result.func_70067_L(), sqDistance);
        return entityRaytraceResult;
    }

    public static final Vector3d getVectorForRotation(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = MathHelper.func_76134_b((float)f1);
        float f3 = MathHelper.func_76126_a((float)f1);
        float f4 = MathHelper.func_76134_b((float)f);
        float f5 = MathHelper.func_76126_a((float)f);
        return new Vector3d((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    @Nullable
    public static EntityRayTraceResult func_221273_a(Entity p_221273_0_, Vector3d p_221273_1_, Vector3d p_221273_2_, AxisAlignedBB p_221273_3_, Predicate<Entity> p_221273_4_, double p_221273_5_) {
        World world = p_221273_0_.field_70170_p;
        double d0 = p_221273_5_;
        Entity entity = null;
        Vector3d Vector3d2 = null;
        for (Entity entity1 : world.func_175674_a(p_221273_0_, p_221273_3_, p_221273_4_)) {
            Vector3d Vector3d1;
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            Optional optional = axisalignedbb.func_216365_b(p_221273_1_, p_221273_2_);
            if (axisalignedbb.func_72318_a(p_221273_1_)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                Vector3d2 = optional.orElse(p_221273_1_);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = p_221273_1_.func_72436_e(Vector3d1 = (Vector3d)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.func_184208_bv() == p_221273_0_.func_184208_bv()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                Vector3d2 = Vector3d1;
                continue;
            }
            entity = entity1;
            Vector3d2 = Vector3d1;
            d0 = d1;
        }
        if (entity == null) {
            return null;
        }
        return new EntityRayTraceResult(entity, Vector3d2);
    }
}

